<?php
/**
 * Visforms captcha html for default layout
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Site\Recaptcha\Recaptcha;
use Joomla\CMS\Layout\LayoutHelper;

if (!empty($displayData)) :
	if (isset($displayData['form'])) :
        $form = $displayData['form'];
		$captcha = New Recaptcha($form);
		if ($captcha->isEnabled()) :
			$input = $captcha->render();
			$form = $displayData['form'];
			$name = 'g-recaptcha-response';
			$errorDivClass = 'fc-tbx' . $name . '_field';
			$html = array();
			if (isset($form->captcha) && (int) $form->captcha === 4) {
				$tooltip = (!empty($form->captchacustominfo)) ? ' title="'. htmlspecialchars($form->captchacustominfo, ENT_COMPAT, 'UTF-8') .'" data-bs-toogle' : '';
				$html[] = '<div class="captchaCont required">';
				// Create a div with the right class where we can put the validation errors into
				$html[] = '<div class="' . $errorDivClass . '"></div>';
                $html[] = LayoutHelper::render('visforms.captcha.default.label', array('form' => $form, 'name' => $name), null, array('component' => 'com_visforms'));
				$html[] = $input;
				if (!empty($form->captchacustominfo)) {
					HTMLHelper::_('visforms.visformsTooltip');
				}
				$html[] = '</div>';
			}
			echo implode('', $html);
		endif;
	endif;
endif;

        