<?php
/**
 * Visforms edit controller
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

namespace Visolutions\Component\Visforms\Site\Controller;
 
// no direct access
defined('_JEXEC') or die( 'Restricted access' );

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\MVC\Controller\BaseController as JoomlaBaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Uri\Uri;
use Joomla\Input\Input;
use Visolutions\Component\Visforms\Site\Log\VisformsLogTrait;

class BaseFormController extends JoomlaBaseController {
    use VisformsLogTrait;

	public function __construct($config = array(), ?MVCFactoryInterface $factory = null, ?CMSApplicationInterface $app = null, ?Input $input = null) {
		parent::__construct($config, $factory, $app, $input);
        $this->initializeLogger('visformssubmit');
	}
    protected function getFallbackRedirect() {
        // no redirect URL given.
        // redirect to base
        // add tmpl URL parameter, if given
        $tmpUrl = new Uri(Uri::base());
        if ($tmpl = $this->input->get('tmpl')) {
            $query = $tmpUrl->getQuery(true);
            $query['tmpl'] = $tmpl;
            $tmpUrl->setQuery($query);
        }
        return $tmpUrl->toString();
    }
}
?>