<?php
/**
 * Visforms field number class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Visolutions\Component\Visforms\Site\Model\VisformsModel as VisformsModelSite;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;
use Visolutions\Component\Visforms\Site\Lib\Message\NumberMessage as ErrorMessage;
use Visolutions\Component\Visforms\Site\Lib\Validation\NumberValidation;

class NumberField extends TextField
{

	protected function setField(): void {
		// preprocessing field
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
        $this->prepareFieldForNoEditSqlProcess();
        $this->unsetDeselectedEditViewValidations();
        $this->setCustomPhpErrorMsg();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
		$this->setIsConditional();
		// uses fillWith() from VisformsFieldText
        $this->fillWith();
		$this->removeInvalidQueryValues();
		$this->setEditValue();
		$this->setConfigurationDefault();
		$this->setEditOnlyFieldDbValue();
		$this->setFieldDefaultValue();
		$this->setDbValue();
		$this->setRedirectParam();
		$this->escapeCustomRegex();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->mendInvalidUncheckedValue();
		$this->setEnterKeyAction();
		$this->setShowRequiredAsterix();
        $this->replaceLabelWithCustomText();
	}

	protected function setFieldDefaultValue(): void {
		$field = $this->field;
		if ($this->form->displayState === VisformsModelSite::$displayStateIsNewEditData) {
			if ((isset($this->field->editValue))) {
				$this->field->attribute_value = $this->field->editValue;
			}
			$this->field->dataSource = 'db';
			return;
		}
		// if we have a POST Value, we use this
		if ((count($_POST) > 0) && isset($_POST['postid']) && ($_POST['postid'] == $this->form->id)) {
			// this will create a error message on form display
			$this->validateUserInput('postValue');
			// $_POST is not set if field was disabled when form was submitted
			if (isset($_POST[$field->name])) {
				// use post value for further validation and if form is not valid as re-display value
				$this->field->attribute_value = $this->postValue;
			} // set to empty, if the field is disabled and the form is re-displayed it will be reset to the default after business logic is performed
			else {
				$this->field->attribute_value = $this->field->configurationDefault;
			}
			$this->field->dataSource = 'post';
			return;
		}

		// if we have a GET Value and field may use GET values, we uses this
		if (isset($field->allowurlparam) && ($field->allowurlparam == true)) {
			$urlparams = Factory::getApplication()->getUserState('com_visforms.urlparams.' . $this->form->context, null);
			if (!empty($urlparams) && (is_array($urlparams)) && (isset($urlparams[$this->field->name]))) {
				$queryValue = $urlparams[$this->field->name];
			}
			if (isset($queryValue)) {
				$this->field->attribute_value = $queryValue;
				$this->field->dataSource = 'query';
				return;
			}
		}
	}

	protected function validateUserInput($inputType) {
		$type = $this->type;
		$value = $this->$inputType;
		// empty values is valid
		if (empty($value)) {
			return;
		}
		// if a value is set we test it is a valid number (which still may have dots and commas)
        $validation = new NumberValidation(array('value' => $value));
		if (!$validation->validate()) {
            // invalid user inputs - set field->isValid to false
            $this->field->isValid = false;
            // set the Error Message
            $message = new ErrorMessage($this->field->label, $this->field->custom_php_error);
            $error = $message->getMessage();
            $this->setErrorMessageInForm($error);
		}
	}

	protected function removeInvalidQueryValues() {
		$type = $this->type;
		$app = Factory::getApplication();
		$urlparams = $app->getUserState('com_visforms.urlparams.' . $this->form->context);
		if (empty($urlparams) || !is_array($urlparams) || !isset($urlparams[$this->field->name])) {
			return;
		}
		$queryValue = $urlparams[$this->field->name];
		// empty string is a valid value (= field value is not set)
		if (($queryValue !== '')) {
		    $validation = new NumberValidation(array('value' => $queryValue));
			$valid = $validation->validate();
			if (empty($valid)) {
				// remove invalid queryValue ulrparams array and set urlparams to Null if the array is empty
				unset($urlparams[$this->field->name]);
				if (!(count($urlparams) > 0)) {
					$urlparams = null;
				}
				$app->setUserState('com_visforms.urlparams.' . $this->form->context, $urlparams);
			}
		}
	}
}