<?php
/**
 * Visforms decorator class for HTML controls
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Control\Decorator;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\LayoutHelper;
use Visolutions\Component\Visforms\Site\Lib\Html\Control\Control;
use Visolutions\Component\Visforms\Site\Lib\Layout\Helper\Uikit3FieldLayoutHelper;

class Uikit3EditDecorator extends Decorator
{
	public function __construct(Control $control) {
		parent::__construct($control);
		$this->fieldHelper = new Uikit3FieldLayoutHelper();
		$this->fieldHelper->setField($this->control->getField()->getField());
	}

	protected function decorate() {

		$control = $this->control;
		$field = $control->getField()->getField();
		$clabel = $control->createlabel();
		$ccontrol = $control->getControlHtml();
		$ccustomtext = $control->getCustomText();
		$field->ctrlGroupUikit3Classes = $control->getCtClasses();
		return LayoutHelper::render('visforms.decorators.edituikit3', array('field' => $field, 'clabel' => $clabel, 'ccontrol' => $ccontrol, 'ccustomtext' => $ccustomtext), null, array('component' => 'com_visforms'));
	}
}

?>