<?php
/**
 * Visforms HTML class for file fields
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class FileField extends TextField
{

	public function __construct($field, $decorable, $attribute_type) {
		$attribute_type = "file";
		parent::__construct($field, $decorable, $attribute_type);
	}

    // bootstrap 5
    public function setControlBt5HtmlClasses($field) {
        return $field;
    }

	// uikit 3
	public function setUikit3ControlHtmlClasses($field) {
		return $field;
	}

	public function removeUnsupportedShowLabel($field) {
		unset($field->show_label);
		return $field;
	}
}