<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class LocationField extends TextField
{
	public function __construct($field, $decorable, $attribute_type) {
		parent::__construct($field, false, 'text');
	}

    // create an array of HTML attributes for the HTML control
	public function getFieldAttributeArray() {
		$attributeArray = parent::getFieldAttributeArray();
		if (!isset($attributeArray['class'])) {
			$attributeArray['class'] = '';
		}
		$attributeArray['class'] .= ' input-small';
		if (isset($attributeArray['value_lat'])) {
			unset($attributeArray['value_lat']);
		}
		if (isset($attributeArray['value_lng'])) {
			unset($attributeArray['value_lng']);
		}
		return $attributeArray;
	}

    // bootstrap 5
    public function setControlBt5HtmlClasses($field) {
        $field->attribute_class = ' locationinput form-control form-control-sm';
        return $field;
    }
	// uikit 3
	public function setUikit3ControlHtmlClasses($field) {
		$field->attribute_class = " locationinput uk-input uk-form-small uk-margin-right";
		return $field;
	}

	public function removeUnsupportedShowLabel($field) {
		unset($field->show_label);
		return $field;
	}
}