<?php
/**
 * Visforms HTML class for multicheckbox
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class MulticheckboxField extends RadioField
{
    protected $isMutable = false;

    public function __construct($field, $decorable, $attribute_type)
    {
        $attribute_type = "checkbox";
        parent::__construct($field, $decorable, $attribute_type);
    }

    // uikit 3
	public function setUikit3ControlHtmlClasses($field) {
		$field->attribute_class = " uk-checkbox";
		return $field;
	}

    protected function setRoleAttribute() {
        $this->field->attribute_role = 'checkbox';
    }
}