<?php
/**
 * Visforms HTML class for selects
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class SelectField extends BaseHtmlField
{
    protected $isMutable = false;

    // create an array of HTML attributes for the HTML control
	public function getFieldAttributeArray() {
		$attributeArray = array('class' => '');
        // HTML attributes are stored in xml-definition-fields with name that ends on _attribute_attributename (i.e. _attribute_checked)
        // names from xml field definition are used, to create the HTML attributes for the control
        // in the xml-definition file each form field is represented by a fieldset
        // in the xml-definition file each form field should have a xml-definition-field with a name that ends on _attribute_class
        // the following code converts the xml-definition-field-names to HTML attribute names and sets the values for the HTML attributes
		foreach ($this->field as $name => $value) {
			if (!is_array($value)) {
				if (str_contains($name, 'attribute_')) {
					if ($name == 'attribute_required') {
						$attributeArray['aria-required'] = 'true';
					}
					if ($value || $name == 'attribute_class') {
						$newname = str_replace('attribute_', "", $name);
						if ($newname == "class") {
							$value = $value . (!empty($value) ? ' ' : '') . $this->field->fieldCSSclass;
							$attributeArray[$newname] .= $value;
						}
						else {
							$attributeArray[$newname] = $value;
						}
					}
				}
				if ($name == 'id') {
					$attributeArray['data-error-container-id'] = 'fc-tbxfield' . $value;
				}
				if (($name == 'isDisabled') && ($value == true)) {
					$attributeArray['class'] .= " ignore";
					$attributeArray['disabled'] = "disabled";
				}
				if (($name == 'isDisplayChanger') && ($value == true)) {
					$attributeArray['class'] .= " displayChanger";
				}
				if (($name == 'isValid') && ($value == false)) {
					$attributeArray['class'] .= " error";
				}
				$attributeArray['aria-labelledby'] = $this->field->name . 'lbl';
			}
		}
		return $attributeArray;
	}

    // bootstrap 5
    public function setControlBt5HtmlClasses($field) {
	    if ($field->typefield == 'selectsql' && !empty($field->render_as_datalist)) {
            return $field;
        }
        $field->attribute_class = " form-select";
        return $field;
    }

	// uikit 3
	public function setUikit3ControlHtmlClasses($field) {
		$field->attribute_class = " uk-select";
		return $field;
	}

	public function removeUnsupportedShowLabel($field) {
		unset($field->show_label);
		return $field;
	}

    public function makeFieldUneditable($field) {
        $field->{'attribute_data-readonly'} = "1";
        $field->{'attribute_aria-readonly'} = "true";
        $field->noFocus = true;
        $this->setRoleAttribute();
        // everything else is done with javascript; no further actions required
        return $field;
    }

    protected function setRoleAttribute() {
        $this->field->attribute_role = 'listbox';
    }
}