<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 5.3
 */

namespace Visolutions\Component\Visforms\Site\Model\Helper\Mail;

// no direct access
defined('_JEXEC') or die('Restricted access');

abstract class BaseMailAdapter
{
    protected $form;
    protected $caller;
    protected $resultmailsettings;
    protected $receiptmailsettings;
    protected $customresultmailsettings;
    protected $customreceiptmailsettings;
    protected $prefix;
    protected $formreceiptmailsettings;
    protected $formresultmailsettings;
    public function __construct($form, $caller)
    {
        $this->form = $form;
        $this->caller = $caller;
        $this->prefix = $this->getPrefix();
        $this->setFormReceiptMailSettings();
        $this->setFormResultMailSettings();
        $this->receiptmailsettings = array(
            $this->prefix .'emailreceipt' => '',
            'emailreceiptsubject' => '',
            'emailreceiptfrom' => '',
            'emailreceiptfromname' => '',
            'emailreceiptcc' => '',
            'emailreceiptbcc' => '',
            'emailreceiptreplyto' => '',
            'emailreceipttext' => '',
            'emailreceiptincfield' => '',
            'emailreceipthideemptyfields' => '',
	        'emailreceiptemptycaliszero' => '',
            'emailreceiptincdatarecordid' => '',
            'emailreceiptinccreated' => '',
            'emailreceiptincformtitle' => '',
            'emailreceiptincip' => '',
	        'emailrecipientincfilepath' => '',
            'emailreceiptincfile' => '',
            'emailreceiptloggingtype' => ''
        );
        $this->resultmailsettings = array(
            $this->prefix . 'emailresult' => '',
            'emailfrom' => '',
            'emailfromname' => '',
            'emailto' => '',
            'emailcc' => '',
            'emailbcc' => '',
            'subject' => '',
            'emailresulttext' => '',
            'emailresultincfield' => '',
            'emailresulthideemptyfields' => '',
	        'emailresultemptycaliszero' => '',
            'emailresultincdatarecordid' => '',
            'emailresultinccreated' => '',
            'emailresultincformtitle' => '',
            'emailresultincip' => '',
            'receiptmailaslink' => '',
	        'emailresultincfilepath' => '1',
            'emailresultincfile' => '',
            'emailresultloggingtype' => ''
        );
        $this->getCustomreceiptmailsettings();
        $this->getCustomresultmailsettings();
    }

    /* @deprecated  5.3 will be removed in Visforms 6.0 without replacement
     *              Use  instead
     */
    public static function getInstance($form, $caller) {
        switch ($caller) {
            case "vfedit" :
                return new EditMailAdapter($form, $caller);
            default:
                return new FormMailAdapter($form, $caller);
        }
    }

    abstract public function result();
    abstract public function receipt();
    abstract protected function getPrefix();
    abstract protected function setFormReceiptMailSettings();
    abstract protected function setFormResultMailSettings();
    protected function getCustomreceiptmailsettings() {
        $this->customreceiptmailsettings = array();
    }
    protected function getCustomresultmailsettings() {
        $this->customresultmailsettings = array();
    }
}