<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 5.3
 */

namespace Visolutions\Component\Visforms\Site\Model\Helper\Mail;

// no direct access
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

defined('_JEXEC') or die('Restricted access');


class EditMailDataHelper extends BaseMailDataHelper{

    public function getMailIncludeData() {
        $visform = $this->form;
        $type = $this->type;
        $paramname = 'editemail' . $type . 'modifiedonly';
        $modifiedOnly = (!empty($visform->$paramname)) ? true : false; // true;
        $data = array();
        if (!empty($modifiedOnly)) {
            $data[] = Text::_('COM_VISFORMS_INCLUDE_MODIFIED_ONLY');
        }
        foreach ($visform->fields as $field) {
            $fieldValue = '';
            $label = (empty($field->customlabelformail)) ? $field->label : $field->customlabelformail;
            if (!empty($field->isButton)) {
                continue;
            }
            if ($field->typefield == 'pagebreak') {
                continue;
            }
            if ($field->typefield == 'fieldsep') {
                continue;
            }
            if (!empty($field->isDisabled)) {
                continue;
            }
            if (!empty($modifiedOnly) && empty($field->ismfd)) {
                continue;
            }
            switch ($type) {
                case 'result' :
                    if (empty($field->includeinresultmail)) {
                        continue 2;
                    }
                    break;
                default :
                    if (empty($field->includeinreceiptmail)) {
                        continue 2;
                    }
                    break;
            }
            if ($field->typefield == 'file' && ((isset($_FILES[$field->name]['name']) && $_FILES[$field->name]['name'] != '') || (isset($field->orgfile->link) && $field->orgfile->link != '') || (isset($field->orgfile->name) && $field->orgfile->name != '') || (isset($field->orgfile->filepath) && $field->orgfile->filepath != ''))) {
                $deleteFlagId = $field->name . '-filedelete';
                $deleteFlagValue = Factory::getApplication()->getInput()->get($deleteFlagId);
                switch ($type) {
                    case 'admin' :
                        if (isset($field->file)) {
                            if (!empty($visform->emailresultincfilepath) && isset($field->file['filelink'])) {
                                $fieldValue = $field->file['filelink'];
                            }
                            else {
                                $fieldValue = (isset($field->file['new_name'])) ? $field->file['new_name'] : '';
                            }
                        }
                        else if (isset($field->orgfile) && empty($deleteFlagValue)) {
                            if (!empty($visform->emailresultincfilepath) && isset($field->orgfile->link)) {
                                $fieldValue = $field->orgfile->link;
                            }
                            else {
                                $fieldValue = $field->orgfile->filepath;
                            }
                        }
                        break;
                    default :
                        if (isset($field->file)) {
                            if ((!empty($visform->emailrecipientincfilepath)) && (isset($field->file['filelink']))) {
                                $fieldValue = $field->file['filelink'];
                            }
                            else {
                                $fieldValue = $field->file['name_org'];
                            }
                        }
                        else if (isset($field->orgfile) && empty($deleteFlagValue)) {
                            if ((!empty($visform->emailrecipientincfilepath)) && isset($field->orgfile->link)) {
                                $fieldValue = $field->orgfile->link;
                            }
                            else {
                                $fieldValue = $field->orgfile->name;
                            }
                        }
                        break;
                }
            }
            else if ($field->typefield == 'signature') {
                // embed binary png
                $layout = new FileLayout('visforms.datas.fields.signature', null);
                $layout->setOptions(array('component' => 'com_visforms'));
                $fieldValue = $layout->render(array('field' => $field, 'data' => $field->dbValue));
            }
            else if ($field->typefield == 'textarea') {
                if (!empty($field->keepBr)) {
                    $fieldValue = HTMLHelper::_('visforms.replaceLinebreaks', $field->dbValue, "<br />");
                }
                else {
                    $fieldValue = HTMLHelper::_('visforms.replaceLinebreaks', $field->dbValue, " ");
                }
            }
            else {
                if (isset($field->dbValue)) {
                    $fieldValue = HTMLHelper::_('visformsselect.removeNullbyte', $field->dbValue);
                }
                else {
                    // fallback set to ""
                    $fieldValue = "";
                }
            }
            // stop execution for this field if fieldvalue is empty and form option is set to hide empty fields in data included in mail
            switch ($type) {
                case 'admin' :
                    if (!empty($visform->emailresulthideemptyfields)) {
                        if (($field->typefield !== 'calculation') && ($fieldValue === '')) {
                            continue 2;
                        }
                        if (($field->typefield === 'calculation') && (!empty($visform->emailresultemptycaliszero)) && (VisformsHelper::checkNumberValueIsZero($fieldValue))) {
                            continue 2;
                        }
                    }
                    break;
                default :
                    if (!empty($visform->emailreceipthideemptyfields)) {
                        if (($field->typefield !== 'calculation') && ($fieldValue === '')) {
                            continue 2;
                        }
                        if (($field->typefield === 'calculation') && (!empty($visform->emailreceiptemptycaliszero)) && (VisformsHelper::checkNumberValueIsZero($fieldValue))) {
                            continue 2;
                        }
                    }
                    break;
            }
            if (($type == 'admin') && (!empty($visform->receiptmailaslink)) && ($field->typefield == 'email')) {
                $fieldValue = '<a href="mailto:' . $fieldValue . '">' . $fieldValue . '</a>';
            }
            $data[] = $label . " : " . $fieldValue;
        }
        return implode("<br />", $data);
    }
}